# datasets/utils.py
from __future__ import annotations

import os
from pathlib import Path
from typing import Optional

DEFAULT_CACHE_ENV = "CTMC_DATASET_CACHE"

def get_cache_dir(cache_dir: Optional[str] = None) -> Path:
    """
    Resolve a cache directory for datasets.
    Priority: arg -> env:CTMC_DATASET_CACHE -> ~/.cache/ctmc_datasets
    """
    if cache_dir is not None:
        p = Path(cache_dir)
    else:
        p = Path(os.environ.get(DEFAULT_CACHE_ENV, Path.home() / ".cache" / "ctmc_datasets"))
    p.mkdir(parents=True, exist_ok=True)
    return p
